<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use App\Models\Product;
use App\Http\Requests\Tag\TagRequest;
use App\Http\Resources\TagResource;
use App\Http\Resources\ProductResource;

class TagController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tags = Tag::inRandomOrder()->limit(8)->get();
        return \SuccessData(__('public.Show'), $tags);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(TagRequest $request)
    {
        $tag = Tag::create($request->validated());
        return \SuccessData(__('public.tag_created'), new TagResource($tag->load('products')));
    }

    /**
     * Display the specified resource.
     */
    public function show(Tag $tag)
    {
        return \SuccessData(__('public.tag_retrieved'), new TagResource($tag->load('products')));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(TagRequest $request, Tag $tag)
    {
        $tag->update($request->validated());
        return \SuccessData(__('public.tag_updated'), new TagResource($tag->load('products')));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Tag $tag)
    {
        $tag->delete();
        return \SuccessData(__('public.tag_deleted'), null);
    }
}
