<?php

namespace App\Http\Controllers;

use App\Models\OrderItem;
use App\Http\Requests\Order\OrderItemRequest;
use App\Http\Resources\OrderItemResource;

class OrderItemController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $orderItems = OrderItem::with(['order', 'product'])->get();
        return \SuccessData(__('public.order_items_retrieved'), OrderItemResource::collection($orderItems));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(OrderItemRequest $request)
    {
        $orderItem = OrderItem::create($request->validated());
        return \SuccessData(__('public.order_item_created'), new OrderItemResource($orderItem->load(['order', 'product'])));
    }

    /**
     * Display the specified resource.
     */
    public function show(OrderItem $orderItem)
    {
        return \SuccessData(__('public.order_item_retrieved'), new OrderItemResource($orderItem->load(['order', 'product'])));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(OrderItemRequest $request, OrderItem $orderItem)
    {
        $orderItem->update($request->validated());
        return \SuccessData(__('public.order_item_updated'), new OrderItemResource($orderItem->load(['order', 'product'])));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(OrderItem $orderItem)
    {
        $orderItem->delete();
        return \SuccessData(__('public.order_item_deleted'), null);
    }
}
