<?php

namespace App\Http\Controllers;

use App\Models\HomeAd;
use App\Http\Requests\HomeAds\HomeAdRequest;
use App\Http\Resources\HomeAdResource;

class HomeAdController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $homeAds = HomeAd::all();
        return \SuccessData(__('public.home_ads_retrieved'), HomeAdResource::collection($homeAds));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(HomeAdRequest $request)
    {
        $homeAd = $request->validated();
        $path = 'Images/HomeAds/';
        $arr['image'] = \uploadImage($request->image, $path);
        HomeAd::create($arr);
        return \Success(__('public.home_ad_created'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(HomeAd $homeAd)
    {
        $homeAd->delete();
        return \SuccessData(__('public.home_ad_deleted'), null);
    }
}
